//
//  MCQuickSearchView.h
//  MCApplication
//
//  Created by Ali Lalani on 07/12/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCNibLoadingView.h"
#import "MCMenuManagerSupportProtocol.h"
#import "MCDisplayStateProtocol.h"

@class MCArrayController, MCSplitView, MCTableView, MCWebKitTemplateView,MCFakeTableHeaderView,MCTableHeaderToggleButtonBar;
@class MCPDatabaseObjectContext;
@interface MCQuickSearchView : MCNibLoadingView <MCMenuManagerSupport,MCDisplayState> {
	IBOutlet NSProgressIndicator   *progressIndicator;
	IBOutlet MCArrayController     *resultsController;
	IBOutlet NSTextField           *resultsDescriptionField;
	IBOutlet MCTableView           *resultsTable;
	IBOutlet NSSearchField         *searchField;
	IBOutlet MCSplitView           *splitView;
	IBOutlet MCWebKitTemplateView  *templateView;
	IBOutlet MCFakeTableHeaderView *tableHeader;
	IBOutlet MCFakeTableHeaderView *webKitTableHeader;
	
	MCTableHeaderToggleButtonBar *buttonBar;

	id document;
	id delegate;
	
	NSArray *applicableEntities;

	// DISPLAY STATE
	NSMutableDictionary *displayState;
	id                   displayStateDelegate;

	BOOL showsAllEntities; // if this is YES, assumes that no entity qualifier is needed if all buttons are on
}
- (void)configureWithButtonIdentifiers:(NSArray *)idents;

- (NSArray *)parseSearchStringToParts:(NSString *)str;
- (NSMenu *)generateSearchFieldMenu;
- (void)updateMenuFromButtonBar;
- (void)syncWebKitTableHeaderWithSplitOrientation;

#pragma mark Actions
- (void)openObjects:(id)sender;
- (IBAction)search:(id)sender;
- (IBAction)toggleSplitOrientation:(id)sender;

#pragma mark DisplayStateReadWrite
- (void)writeSplitViewProportionsToDisplayState;
- (void)readSplitViewProportionsFromDisplayState;
- (void)writeSelectedButtonsToDisplayState;
- (void)readSelectedButtonsFromDisplayState;

#pragma mark Accessors
- (MCTableView *)resultsTable;
- (NSSearchField *)searchField;
- (MCArrayController *)resultsController;
- (MCPDatabaseObjectContext *)objectContext;

- (NSArray *)applicableEntities;
- (void)setApplicableEntities:(NSArray *)anApplicableEntities;

- (BOOL)showsAllEntities;
- (void)setShowsAllEntities:(BOOL)flag;

- (id)document;
- (void)setDocument:(id)aDocument;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (MCTableHeaderToggleButtonBar *)buttonBar;
- (void)setButtonBar:(MCTableHeaderToggleButtonBar *)aButtonBar;
@end

@interface NSObject (QuickSearchViewDelegate)
- (void)quickSearchViewDidDoubleClick:(MCQuickSearchView *)qsView;
@end
